package ru.yandex.webmaster3.core.http;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/**
 * @author avhaliullin
 */
public class ActionProxyHandler extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(ActionProxyHandler.class);

    private static final String PROXY_ACTIONS_PROPERTY = "PROXY_ACTIONS";
    private final ServletContextHandler servletContextHandler = new ServletContextHandler(ServletContextHandler.NO_SESSIONS);

    private String proxyTo;
    private String proxyToHost;
    private int proxyToPort;


    //    private final ProxyServlet proxyServlet = new ProxyServlet();
    private final Set<String> proxyRequests = new HashSet<>();

    public void init() {
        String[] parts = proxyTo.split(":");
        proxyToHost = parts[0];
        proxyToPort = Integer.parseInt(parts[1]);
        log.info("Proxying to {} port {}", proxyToHost, proxyToPort);
        servletContextHandler.addServlet(ProxyServlet.class, "/");
//        servletContextHandler.setInitParameter("viaHost", proxyTo);
        String actionsString = System.getenv(PROXY_ACTIONS_PROPERTY);
        if (!StringUtils.isEmpty(actionsString)) {
            String[] actions = actionsString.split(",");
            for (String action : actions) {
                proxyRequests.add(action + ".json");
            }
        }
    }

    @Override
    public void handle(String s, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
//        ProxyServlet proxyServlet = new ProxyServlet();
        if (proxyRequests.contains(s)) {
            log.info("Proxying request {} to {}", s, proxyTo);
            request.setServerName(proxyToHost);
            request.setServerPort(proxyToPort);
            servletContextHandler.handle(s, request, httpServletRequest, httpServletResponse);
            request.setHandled(true);
        }
//        servletContextHandler.handle(s, request, httpServletRequest, httpServletResponse);
    }

    @Override
    public void setServer(Server server) {
        super.setServer(server);
        servletContextHandler.setServer(server);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        servletContextHandler.start();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        servletContextHandler.stop();
    }

    @Required
    public void setProxyTo(String proxyTo) {
        this.proxyTo = proxyTo;
    }
}
