package ru.yandex.webmaster3.core.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author aherman
 */
public interface ActionResponse {
    @JsonIgnore
    ActionStatus getRequestStatus();

    interface NormalResponse extends ActionResponse {
        default ActionStatus getRequestStatus() {
            return ActionStatus.SUCCESS;
        }

        /**
         * Для отдачи ответа наружу as is, без добавления каких либо дополнительных полей,
         * типа trace, request и т.д. Используется, если ответ отдается какому то сторонннему
         * сервису, который ожидает его во определенном формате.
         *
         * @return true, если ответ нужно отдать как есть
         */
        @JsonIgnore
        default boolean isUndecoratedResponse() {
            return false;
        }
    }

    interface ErrorResponse extends ActionResponse {
        Enum<?> getCode();

        @Override
        default ActionStatus getRequestStatus() {
            return ActionStatus.FAIL;
        }

        // TODO: кажется, что все нижеследующие методы особо и не нужны и их неплохо бы выпилить.
        default Enum<?> getSubsystem()  {
            return null;
        }

        @JsonProperty("class")
        default Class<?> getClazz() {
            return null;
        }

        default String getMessage() {
            return null;
        }

        default String getStackTrace() {
            return null;
        }
    }
}
