package ru.yandex.webmaster3.core.http;

import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import ru.yandex.autodoc.common.doc.params.ParamType;
import ru.yandex.autodoc.common.doc.types.ValueType;

import java.lang.reflect.Type;

/**
 * @author aherman
 */
public class DateTimeParameterConverter implements ParameterConverter {
    @Override
    public Object convert(String value, Type toType) {
        if (toType == Instant.class) {
            return Instant.parse(value);
        } else if (toType == LocalDate.class) {
            return LocalDate.parse(value);
        } else if (toType == DateTime.class) {
            return DateTime.parse(value);
        }
        return null;
    }

    @Override
    public ValueType describeType(Type type) {
        if (type == Instant.class || type == DateTime.class) {
            return new ValueType.Primitive("yyyy-MM-ddTHH:mm:ss,sssZ", ValueType.STRING, "2016-01-01T00:00:00,000+0300");
        } else if (type == LocalDate.class) {
            return new ValueType.Primitive("yyyy-MM-dd", ValueType.STRING, "2016-01-01");
        } else {
            return null;
        }
    }
}
