package ru.yandex.webmaster3.core.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.xerces.impl.dv.util.Base64;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

/**
 * @author: ishalaru
 * DATE: 17.05.2019
 */
public class FileParameterTransfer {
    private static final String MIME_APPLICATION_X_GZIP = "application/x-gzip";
    private String data;
    private String contentType;
    private String name;
    private String fileName;
    private long size;

    public FileParameterTransfer(@JsonProperty("data") String data,
                                 @JsonProperty("contentType") String contentType,
                                 @JsonProperty("name") String name,
                                 @JsonProperty("fileName") String fileName,
                                 @JsonProperty("size") long size) {
        this.data = data;
        this.contentType = contentType;
        this.name = name;
        this.fileName = fileName;
        this.size = size;
    }

    public static String convertToString(byte[] data) {
        return Base64.encode(data);
    }

    @JsonIgnore
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = new ByteArrayInputStream(Base64.decode(data));
        if (MIME_APPLICATION_X_GZIP.equals(this.getContentType())) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public String getData() {
        return data;
    }

    public String getContentType() {
        return contentType;
    }

    public String getName() {
        return name;
    }

    public String getFileName() {
        return fileName;
    }

    public long getSize() {
        return size;
    }
}
