package ru.yandex.webmaster3.core.http;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import org.joda.time.DateTime;

/**
 * <pre><code>
 * {
 *     "application": "webmaster-viewer",
 *     "version": "1.2.3",
 *     "startDate": "2014-01-10T15:23:48+04:00"
 *     "action": "host/limits/getForHost",
 *     "status": "success",
 *     "duration": "128",
 *
 *     "request": {
 *         ...
 *     },
 *
 *     "response": {
 *         ...
 *     },
 *
 *     "errors": [{
 *         "code": "",
 *         "class": "",
 *         "message": "",
 *         "stackTrace": ""
 *     }]
 * }
 * </code></pre>

 * @author aherman
 */
@JacksonXmlRootElement(localName = "response")
public class GenericActionResponse {
    private final String application;
    private final String version;
    private final DateTime startDate;
    private final String action;
    private final ActionStatus status;
    private final long duration;

    private final Object request;
    private final Object data;
    private final RequestTrace trace;
    private final ActionResponse.ErrorResponse[] errors;

    GenericActionResponse(String application, String version, DateTime startDate, String action,
            ActionStatus status, long duration, Object request, Object response,
            ActionResponse.ErrorResponse error, RequestTrace trace)
    {
        this.application = application;
        this.version = version;
        this.startDate = startDate;
        this.action = action;
        this.status = status;
        this.duration = duration;
        this.request = request;
        this.data = response;
        this.trace = trace;
        if (error != null) {
            this.errors = new ActionResponse.ErrorResponse[]{error};
        } else {
            this.errors = null;
        }
    }

    public String getApplication() {
        return application;
    }

    public String getVersion() {
        return version;
    }

    public DateTime getStartDate() {
        return startDate;
    }

    public String getAction() {
        return action;
    }

    public ActionStatus getStatus() {
        return status;
    }

    public long getDuration() {
        return duration;
    }

    public Object getRequest() {
        return request;
    }

    public Object getData() {
        return data;
    }

    public RequestTrace getTrace() {
        return trace;
    }

    @JacksonXmlElementWrapper(localName = "errors")
    @JacksonXmlProperty(localName = "error")
    public ActionResponse.ErrorResponse[] getErrors() {
        return errors;
    }
}
