package ru.yandex.webmaster3.core.http;

import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.Lifecycle;

/**
 * @author aherman
 */
public class JettyStarter implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(JettyStarter.class);

    private Server server;

    @Override
    public void start() {
        try {
            server.start();
        } catch (Exception e) {
            log.error("Unable to start Jetty", e);
            try {
                server.stop();
            } catch (Exception e1) {
                log.error("Exception during jetty stop", e);
            }
            throw new RuntimeException("Unable to start jetty", e);
        }
    }

    @Override
    public void stop() {
        try {
            server.stop();
        } catch (Exception e) {
            throw new RuntimeException("Unable to stop jetty", e);
        }
    }

    @Override
    public boolean isRunning() {
        return server.isRunning();
    }

    @Required
    public void setServer(Server server) {
        this.server = server;
    }
}
