package ru.yandex.webmaster3.core.http;

import ru.yandex.webmaster3.core.WebmasterException;

import java.lang.reflect.Type;

/**
 * @author aherman
 */
public interface ParameterConverter extends TypeDescriptionResolver {
    default Object convert(String name, String value, Type toType) {
        try {
            return convert(value, toType);
        } catch (IllegalArgumentException e) {
            throw new WebmasterException("Unable to convert parameter " + name + " to " + toType.getTypeName(),
                    new WebmasterErrorResponse.IllegalParameterValueResponse(getClass(), name, value), e);
        }
    }

    Object convert(String value, Type toType);
}
