package ru.yandex.webmaster3.core.http;

import ru.yandex.autodoc.common.doc.types.ValueType;

import java.lang.reflect.Type;

/**
 * @author aherman
 */
public class PrimitiveParameterConverter implements ParameterConverter {
    @Override
    public Object convert(String value, Type toType) {
        PrimitiveType primitiveType = getPrimitiveType(toType);
        if (primitiveType == null) {
            return null;
        }
        switch (primitiveType) {
            case STRING:
                return value;
            case LONG:
                return getLong(value);
            case INTEGER:
                return getInteger(value);
            case BOOLEAN:
                return Boolean.valueOf(value);
            case DOUBLE:
                return getDouble(value);
            case FLOAT:
                return getFloat(value);
            default:
                throw new RuntimeException("Unknown primitive type " + primitiveType);
        }
    }

    @Override
    public ValueType describeType(Type type) {
        PrimitiveType primitiveType = getPrimitiveType(type);
        if (primitiveType == null) {
            return null;
        }
        switch (primitiveType) {
            case STRING:
                return ValueType.STRING;
            case LONG:
                return ValueType.INT64;
            case INTEGER:
                return ValueType.INT32;
            case BOOLEAN:
                return ValueType.BOOLEAN;
            case DOUBLE:
                return ValueType.DOUBLE;
            case FLOAT:
                return ValueType.SINGLE;
            default:
                throw new RuntimeException("Unknown primitive type " + primitiveType);
        }
    }

    private static Long getLong(String valueStr) {
        return Long.valueOf(valueStr);
    }

    private static Integer getInteger(String valueStr) {
        return Integer.valueOf(valueStr);
    }

    private static Float getFloat(String valueStr) {
        return Float.valueOf(valueStr);
    }

    private static Double getDouble(String valueStr) {
        return Double.valueOf(valueStr);
    }

    private static PrimitiveType getPrimitiveType(Type type) {
        if (type == String.class) {
            return PrimitiveType.STRING;
        } else if (type == Integer.class || type == Integer.TYPE) {
            return PrimitiveType.INTEGER;
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            return PrimitiveType.BOOLEAN;
        } else if (type == Long.class || type == Long.TYPE) {
            return PrimitiveType.LONG;
        } else if (type == Float.class || type == Float.TYPE) {
            return PrimitiveType.FLOAT;
        } else if (type == Double.class || type == Double.TYPE) {
            return PrimitiveType.DOUBLE;
        }
        return null;
    }

    private enum PrimitiveType {
        INTEGER, LONG, FLOAT, BOOLEAN, DOUBLE, STRING
    }
}
