package ru.yandex.webmaster3.core.http;

import ru.yandex.autodoc.common.doc.params.ParamDescriptor;
import ru.yandex.webmaster3.core.http.request.RequestContext;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author aherman
 */
public interface RequestFilter<Req, Err extends ActionResponse.ErrorResponse> {
    /**
     * Собственно логика фильтра. Вызывается на каждый вызов action'а при выполнении двух условий:
     * 1. Запрос action'а подходит под ограничение, которое фильтр накладывает на тип Req (например Req extends SomeType & OtherType)
     * 2. isApplicable для action'а вернул true
     */
    Err beforeRequest(RequestContext ctx, Req req);

    default boolean isApplicable(Action action){
        return true;
    }

    /**
     * Позволяет модифицировать список параметров для отображения в документации.
     * Можно добавить/удалить/изменить описание параметра.
     */
    default List<ParamDescriptor> clarifyParameters(List<ParamDescriptor> params) {
        return params.stream().map(this::clarifyParameter).collect(Collectors.toList());
    }

    /**
     * Если фильтр как-то аффектит поведение каких-то параметров Action'а,
     * то в этом методе можно поменять описание таких параметров, чтобы оно отразилось в доке.
     */
    default ParamDescriptor clarifyParameter(ParamDescriptor param) {
        return param;
    }
}
