package ru.yandex.webmaster3.core.http;

/**
 * @author aherman
 */
enum ResponseFormat {
    UNKNOWN("", ""),

    INFO(".info", "text/html"),
    XML(".xml", "application/xml"),
    JSON(".json", "application/json"),
    CSV(".csv", "text/csv")
    ;

    private final String extension;
    private final String mimeType;

    private ResponseFormat(String extension, String mimeType) {
        this.extension = extension;
        this.mimeType = mimeType;
    }

    public String getExtension() {
        return extension;
    }

    public String getMimeType() {
        return mimeType;
    }

    public static ResponseFormat getResponseFormat(String target) {
        int commaPosition = target.lastIndexOf('.');
        if (commaPosition < 0) {
            return ResponseFormat.JSON;
        }
        String extension = target.substring(commaPosition);
        for (ResponseFormat format : ResponseFormat.values()) {
            if (format.getExtension().equals(extension)) {
                return format;
            }
        }

        return ResponseFormat.UNKNOWN;
    }
}
