package ru.yandex.webmaster3.core.http;

import org.apache.commons.collections4.CollectionUtils;
import ru.yandex.autodoc.common.doc.types.ValueType;
import ru.yandex.webmaster3.core.util.ReflectionUtils;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author avhaliullin
 */
public interface TypeDescriptionResolver {
    ValueType describeType(Type type);

    static TypeDescriptionResolver fromMap(Map<Class<?>, List<TypeDescriptionResolver>> resolvers) {
        return type -> {
            List<Class<?>> allParents = ReflectionUtils.listParents(ReflectionUtils.getClassFromType(type));
            for (Class<?> clazz : allParents) {
                List<TypeDescriptionResolver> resolversChain = resolvers.get(clazz);
                if (CollectionUtils.isEmpty(resolversChain)) {
                    continue;
                }
                ValueType result = resolversChain.stream()
                        .map(r -> r.describeType(type))
                        .filter(Objects::nonNull)
                        .findFirst()
                        .orElse(null);
                if (result != null) {
                    return result;
                }
            }
            return null;
        };
    }
}
