package ru.yandex.webmaster3.core.http;

import org.apache.commons.lang3.StringUtils;
import ru.yandex.autodoc.common.doc.types.ValueType;
import ru.yandex.wmtools.common.error.AbstractWMToolsException;
import ru.yandex.wmtools.common.util.uri.WebmasterUriUtils;

import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * @author avhaliullin
 */
public class URLParameterConverter implements ParameterConverter {
    @Override
    public Object convert(String value, Type toType) {
        if (toType == URL.class) {
            URL url;
            try {
                url = WebmasterUriUtils.toOldUri(value).toURL();
            } catch (AbstractWMToolsException | MalformedURLException | RuntimeException e) {
                throw new IllegalArgumentException(e);
            }

            String host = url.getHost();
            if (StringUtils.isEmpty(host)) {
                host = url.getAuthority();
            }
            if (StringUtils.isEmpty(host)) {
                throw new IllegalArgumentException("Host is empty");
            }
            if (host.indexOf('.') < 0) {
                throw new IllegalArgumentException("Host is first level domain");
            }

            return url;
        }
        return null;
    }

    @Override
    public ValueType describeType(Type type) {
        if (type == URL.class) {
            return new ValueType.Primitive("URL", ValueType.STRING, "http://yandex.ru/");
        }
        return null;
    }
}
