package ru.yandex.webmaster3.core.http;

import ru.yandex.autodoc.common.doc.types.ValueType;

import java.lang.reflect.Type;
import java.util.UUID;

/**
 * @author aherman
 */
public class UUIDParameterConverter implements ParameterConverter {
    @Override
    public Object convert(String value, Type toType) {
        if (toType != UUID.class) {
            return null;
        }

        try {
            return UUID.fromString(value);
        } catch (Exception e) {
            throw new IllegalArgumentException("Isn't valid UUID string: \"" + value + "\"");
        }
    }

    @Override
    public ValueType describeType(Type type) {
        return new ValueType.Primitive("UUID", ValueType.STRING, "c7fe80c0-36e3-11e6-8b2d-df96aa592c0a");
    }
}
