package ru.yandex.webmaster3.core.http;

import java.util.BitSet;

import com.fasterxml.jackson.databind.module.SimpleModule;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.request.PathIdDeserializer;
import ru.yandex.webmaster3.core.http.request.QueryIdDeserializer;
import ru.yandex.webmaster3.core.http.request.WebmasterHostIdDeserializer;
import ru.yandex.webmaster3.core.http.response.PathIdSerializer;
import ru.yandex.webmaster3.core.http.response.QueryIdSerializer;
import ru.yandex.webmaster3.core.http.response.WebmasterHostIdSerializer;
import ru.yandex.webmaster3.core.searchquery.PathId;
import ru.yandex.webmaster3.core.searchquery.QueryId;
import ru.yandex.webmaster3.core.util.joda.jackson.BitSetDeserializer;
import ru.yandex.webmaster3.core.util.joda.jackson.BitSetSerializer;

/**
 * @author aherman
 */
public class WebmasterJsonModule extends SimpleModule {
    public WebmasterJsonModule(boolean useReadableHostname) {
        addSerializer(WebmasterHostId.class, new WebmasterHostIdSerializer(useReadableHostname));
        addDeserializer(WebmasterHostId.class, new WebmasterHostIdDeserializer());

        addSerializer(QueryId.class, new QueryIdSerializer());
        addDeserializer(QueryId.class, new QueryIdDeserializer());

        addSerializer(PathId.class, new PathIdSerializer());
        addDeserializer(PathId.class, new PathIdDeserializer());

        addSerializer(BitSet.class, new BitSetSerializer());
        addDeserializer(BitSet.class, new BitSetDeserializer());
    }
}
