package ru.yandex.webmaster3.core.http.autodoc;

import ru.yandex.autodoc.common.doc.annotation.Description;

import java.util.ArrayDeque;
import java.util.Queue;

/**
 * @author avhaliullin
 */
public class AutodocUtil {
    /**
     * Обходит предков BFS'ом
     *
     * @param clazz
     * @return
     */
    public static String getClassDescription(Class<?> clazz) {
        Queue<Class<?>> classesQueue = new ArrayDeque<>();
        classesQueue.add(clazz);
        while (!classesQueue.isEmpty()) {
            Class<?> cur = classesQueue.poll();
            if (cur.isAnnotationPresent(Description.class)) {
                return cur.getAnnotation(Description.class).value();
            }
            Class<?> superClass = cur.getSuperclass();
            if (superClass != null && superClass != Object.class) {
                classesQueue.offer(cur.getSuperclass());
            }
            for (Class<?> iface : cur.getInterfaces()) {
                classesQueue.offer(iface);
            }
        }
        return null;
    }
}
