package ru.yandex.webmaster3.core.http.autodoc;

import java.lang.reflect.Member;

import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import org.jetbrains.annotations.NotNull;

/**
 * @author avhaliullin
 */

public class FieldRepresentation implements Comparable<FieldRepresentation> {
    public final String name;
    public final FullTypeInfo type;
    public final boolean nullable;
    public final String description;
    public final Member member;
    public final AnnotatedMember annotatedMember;

    FieldRepresentation(String name, FullTypeInfo type, boolean nullable, String description, Member member, AnnotatedMember annotatedMember) {
        this.name = name;
        this.type = type;
        this.nullable = nullable;
        this.description = description;
        this.member = member;
        this.annotatedMember = annotatedMember;
    }

    @Override
    public int compareTo(@NotNull FieldRepresentation o) {
        return name.compareTo(o.name);
    }
}
