package ru.yandex.webmaster3.core.http.autodoc;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Используется для указания поля, по которому сортируется енум
 *
 * @author avhaliullin
 */
@Repeatable(Ordering.class)
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface OrderBy {
    String value();

    boolean reverse() default false;

    NullMode nullMode() default NullMode.FIRST;

    enum NullMode {
        FIRST,
        LAST,
    }
}
