package ru.yandex.webmaster3.core.http.filter;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.WebmasterCommonErrorSystem;

/**
 * @author avhaliullin
 */
public abstract class AbstractFilterError implements ActionResponse.ErrorResponse {
    private final WebmasterCommonErrorSystem system;
    private final String message;
    private final Class<?> clazz;
    private final Enum<?> code;

    public AbstractFilterError(Class<?> clazz, WebmasterCommonErrorSystem system, Enum<?> code, String message) {
        this.system = system;
        this.message = message;
        this.clazz = clazz;
        this.code = code;
    }

    @Override
    public Enum<?> getCode() {
        return code;
    }

    @Override
    public WebmasterCommonErrorSystem getSubsystem(){
        return system;
    }

    @Override
    public Class<?> getClazz() {
        return clazz;
    }

    @Override
    public String getMessage() {
        return message;
    }
}
