package ru.yandex.webmaster3.core.http.filter;

import ru.yandex.autodoc.common.doc.params.ParamDescriptor;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.RequestFilter;
import ru.yandex.webmaster3.core.http.filter.HostIdFilterResponse;
import ru.yandex.webmaster3.core.http.request.RequestContext;
import ru.yandex.webmaster3.core.http.request.WebmasterHostIdConverter;
import ru.yandex.webmaster3.core.http.request.WebmasterHostIdAware;

import java.util.Collections;

/**
 * @author aherman
 */
public class HostIdFilter implements RequestFilter<WebmasterHostIdAware, HostIdFilterResponse> {
    @Override
    public HostIdFilterResponse beforeRequest(RequestContext ctx, WebmasterHostIdAware req) {
        String hostIdString = req.getHostIdString();
        if (hostIdString == null) {
            return new HostIdFilterResponse.IllegalHostIdPassed(getClass(), null);
        }
        WebmasterHostId hostId = WebmasterHostIdConverter.convert(hostIdString);
        if (hostId == null) {
            return new HostIdFilterResponse.IllegalHostIdPassed(getClass(), hostIdString);
        }
        req.setConvertedHostId(hostId);
        return null;
    }

    @Override
    public ParamDescriptor clarifyParameter(ParamDescriptor param) {
        if (param.getName().equals("hostId")) {
            return new ParamDescriptor(param.getName(), true, WebmasterHostIdConverter.PARAM_TYPE, null,
                    "id хоста в запросе", Collections.emptyList());
        } else {
            return param;
        }
    }

}
