package ru.yandex.webmaster3.core.http.filter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WebmasterCommonErrorSystem;

/**
 * @author avhaliullin
 */
public interface HostIdFilterResponse extends ActionResponse.ErrorResponse {
    enum Code {
        REQUEST__ILLEGAL_HOST_ID_PASSED,
    }

    @Description("Передан некорректный id хоста")
    class IllegalHostIdPassed extends AbstractFilterError implements HostIdFilterResponse {
        private final String webmasterHostId;

        public IllegalHostIdPassed(Class<?> clazz, String webmasterHostId) {
            super(clazz, WebmasterCommonErrorSystem.REQUEST, Code.REQUEST__ILLEGAL_HOST_ID_PASSED, "Illegal host id passed");
            this.webmasterHostId = webmasterHostId;
        }

        public String getWebmasterHostId() {
            return webmasterHostId;
        }
    }
}
