package ru.yandex.webmaster3.core.http.filter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.WebmasterCommonErrorSystem;

/**
 * @author avhaliullin
 */
public abstract class UserHostErrors extends AbstractFilterError {
    public enum Code {
        USER__HOST_NOT_VERIFIED,
        USER__HOST_NOT_ADDED,
    }

    public UserHostErrors(Class<?> clazz, Code code, String message) {
        super(clazz, WebmasterCommonErrorSystem.USER, code, message);
    }

    @Description(value = "У пользователя не подтверждены права на хост")
    public static class HostNotVerifiedResponse extends UserHostErrors {
        private final WebmasterHostId webmasterHostId;

        public HostNotVerifiedResponse(Class<?> clazz, WebmasterHostId hostId) {
            super(clazz, Code.USER__HOST_NOT_VERIFIED, "Host not verified");
            this.webmasterHostId = hostId;
        }

        public WebmasterHostId getWebmasterHostId() {return webmasterHostId;}
    }

    @Description(value = "Сайт отсутствует в списке сайтов")
    public static class HostNotAddedResponse extends UserHostErrors {
        private final WebmasterHostId webmasterHostId;

        public HostNotAddedResponse(Class<?> clazz, WebmasterHostId hostId) {
            super(clazz, Code.USER__HOST_NOT_ADDED, "Host not added");
            this.webmasterHostId = hostId;
        }

        public WebmasterHostId getWebmasterHostId() {return webmasterHostId;}
    }
}
