package ru.yandex.webmaster3.core.http.filter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.autodoc.common.doc.params.ParamDescriptor;
import ru.yandex.autodoc.common.doc.params.ParamType;
import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestFilter;
import ru.yandex.webmaster3.core.http.WebmasterCommonErrorSystem;
import ru.yandex.webmaster3.core.http.request.RequestContext;
import ru.yandex.webmaster3.core.http.request.WebmasterUserIdAware;

/**
 * @author aherman
 */
public class WebmasterUserFilter implements RequestFilter<WebmasterUserIdAware, WebmasterUserFilterResponse> {
    @Override
    public WebmasterUserFilterResponse beforeRequest(RequestContext ctx, WebmasterUserIdAware req) {
        long userId = req.getUserId();
        if (userId == 0) {
            return new WebmasterUserFilterResponse.UserNotLoggedIn(getClass());
        }

        // WMC-7648
        if (userId == 785316385) {
            return new WebmasterUserFilterResponse.UserBanned(getClass());
        }

        WebmasterUser user = new WebmasterUser(userId);
        req.setWebmasterUser(user);
        return null;
    }

    @Override
    public ParamDescriptor clarifyParameter(ParamDescriptor param) {
        if (param.getName().equals("userId")) {
            return new ParamDescriptor(param.getName(), true, new ParamType("integer (uid)"), null,
                    "id пользователя", param.getExtraInfos());
        } else {
            return param;
        }
    }
}
