package ru.yandex.webmaster3.core.http.filter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WebmasterCommonErrorSystem;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;

/**
 * @author avhaliullin
 */
public interface WebmasterUserFilterResponse extends ActionResponse.ErrorResponse {
    enum Code {
        USER__NOT_LOGGED_IN,
        USER__BANNED
    }

    class UserNotLoggedIn extends WebmasterErrorResponse implements WebmasterUserFilterResponse {
        public UserNotLoggedIn(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return Code.USER__NOT_LOGGED_IN;}
        @Override public Enum<?> getSubsystem() {return WebmasterCommonErrorSystem.USER;}
        @Override public String getMessage() {return "User not logged in";}
    }

    @Description("Запрос классифицирован как спамерский")
    class UserBanned extends WebmasterErrorResponse implements WebmasterUserFilterResponse {
        public UserBanned(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return Code.USER__BANNED;}
        @Override public Enum<?> getSubsystem() {return WebmasterCommonErrorSystem.USER;}
        @Override public String getMessage() {return "User banned";}
    }
}
