package ru.yandex.webmaster3.core.http.internal;

import ru.yandex.webmaster3.core.http.autodoc.FullTypeInfo;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class ParameterInfo {
    public final Map<Class<? extends Annotation>, List<Annotation>> annotations;
    public final Method method;
    public final PropertyType propertyType;
    public final String name;
    public final String internalName;
    public final boolean required;
    public final FullTypeInfo type;
    public final long maxSize;
    public final String defaultValue;

    public ParameterInfo(Map<Class<? extends Annotation>, List<Annotation>> annotations, Method method,
                         PropertyType propertyType, String name, String internalName, boolean required, FullTypeInfo type, long maxSize, String defaultValue) {
        this.annotations = annotations;
        this.method = method;
        this.propertyType = propertyType;
        this.name = name;
        this.internalName = internalName;
        this.required = required;
        this.type = type;
        this.maxSize = maxSize;
        this.defaultValue = defaultValue;
    }

    public ParameterInfo withName(String name) {
        return new ParameterInfo(annotations, method, propertyType, name, internalName, required, type, maxSize, defaultValue);
    }

    public <A extends Annotation> List<A> getAnnotations(Class<A> type) {
        if (!annotations.containsKey(type)) {
            return Collections.emptyList();
        } else {
            return (List<A>) annotations.get(type);
        }
    }

    public static enum PropertyType {
        GET, JSON, FILE
    }
}
