package ru.yandex.webmaster3.core.http.request;

import ru.yandex.autodoc.common.doc.types.ValueType;
import ru.yandex.webmaster3.core.http.ParameterConverter;
import ru.yandex.webmaster3.core.searchquery.PathId;

import java.lang.reflect.Type;

/**
 * @author lester
 */
public class PathIdConverter implements ParameterConverter {
    @Override
    public Object convert(String value, Type toType) {
        return PathId.fromStringId(value).orElse(null);
    }

    @Override
    public ValueType describeType(Type type) {
        return new ValueType.Primitive("path id (hexadecimal string)", ValueType.STRING, "0a342bff");
    }
}
