package ru.yandex.webmaster3.core.http.request;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.searchquery.PathId;

/**
 * @author lester
 */
public class PathIdDeserializer extends FromStringDeserializer<PathId> {
    public PathIdDeserializer() {
        super(WebmasterHostId.class);
    }

    @Override
    protected PathId _deserialize(String value, DeserializationContext ctxt) {
        return PathId.fromStringId(value).orElseThrow(() -> new IllegalArgumentException("Cannot parse path id from '" + value + "'"));
    }
}
