package ru.yandex.webmaster3.core.http.request;

import ru.yandex.autodoc.common.doc.types.ValueType;
import ru.yandex.webmaster3.core.http.ParameterConverter;
import ru.yandex.webmaster3.core.searchquery.QueryId;

import java.lang.reflect.Type;

/**
 * @author avhaliullin
 */
public class QueryIdConverter implements ParameterConverter {
    @Override
    public Object convert(String value, Type toType) {
        return QueryId.fromStringId(value).orElse(null);
    }

    @Override
    public ValueType describeType(Type type) {
        return new ValueType.Primitive("query id (hexadecimal string)", ValueType.STRING, "0a342bff");
    }
}
