package ru.yandex.webmaster3.core.http.request;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.searchquery.QueryId;

/**
 * @author avhaliullin
 */
public class QueryIdDeserializer extends FromStringDeserializer<QueryId> {
    public QueryIdDeserializer() {
        super(WebmasterHostId.class);
    }

    @Override
    protected QueryId _deserialize(String value, DeserializationContext ctxt) {
        return QueryId.fromStringId(value).orElseThrow(() -> new IllegalArgumentException("Cannot parse query id from '" + value + "'"));
    }
}