package ru.yandex.webmaster3.core.http.request;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

import java.util.UUID;

/**
 * @author avhaliullin
 */
@JsonSerialize(using = ToStringSerializer.class)
public abstract class RequestId {
    public static class BalancerRequestId extends RequestId {
        private final String id;

        public BalancerRequestId(String id) {
            this.id = id;
        }

        public String getId() {
            return id;
        }

        @Override
        public String toString() {
            return id;
        }
    }

    public static class FakeRequestId extends RequestId {
        private final UUID uuid;

        public FakeRequestId(UUID uuid) {
            this.uuid = uuid;
        }

        @Override
        public String toString() {
            return "fake-" + uuid.toString();
        }
    }
}
