package ru.yandex.webmaster3.core.http.request;

import org.apache.commons.lang3.StringUtils;
import ru.yandex.autodoc.common.doc.types.ValueType;
import ru.yandex.webmaster3.core.http.ParameterConverter;

import java.lang.reflect.Type;

/**
 * @author aherman
 */
public class RequestIdConverter implements ParameterConverter {
    @Override
    public Object convert(String value, Type toType) {
        if (!StringUtils.isEmpty(value)) {
            return new RequestId.BalancerRequestId(value);
        } else {
            return null;
        }
    }

    @Override
    public ValueType describeType(Type type) {
        return PARAM_TYPE;
    }

    public static final ValueType PARAM_TYPE = ValueType.STRING;
}
