package ru.yandex.webmaster3.core.http.request;

import ru.yandex.autodoc.common.doc.types.ValueType;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ParameterConverter;
import ru.yandex.webmaster3.core.util.IdUtils;

import java.lang.reflect.Type;

/**
 * @author aherman
 */
public class WebmasterHostIdConverter implements ParameterConverter {
    @Override
    public Object convert(String value, Type toType) {
        return convert(value);
    }

    @Override
    public ValueType describeType(Type type) {
        return PARAM_TYPE;
    }

    public static final ValueType PARAM_TYPE = new ValueType.Primitive("host id", ValueType.STRING, "http:ya.ru:80");

    public static WebmasterHostId convert(String hostIdString) {
        try {
            return IdUtils.webIdStringToHostId(hostIdString, true);
        } catch (Exception e) {
            return null;
        }
    }
}
