package ru.yandex.webmaster3.core.http.request;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.IdUtils;

/**
 * @author avhaliullin
 */
public class WebmasterHostIdDeserializer extends FromStringDeserializer<WebmasterHostId> {
    public WebmasterHostIdDeserializer() {
        super(WebmasterHostId.class);
    }

    @Override
    protected WebmasterHostId _deserialize(String value, DeserializationContext ctxt) {
        return IdUtils.webIdStringToHostId(value, true);
    }
}
