package ru.yandex.webmaster3.core.http.request;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;

import java.util.UUID;

/**
 * @author aherman
 */
public interface WebmasterUserIdAware {
    @Description(value="Паспортный идентификатор пользователя")
    @RequestQueryProperty
    void setUserId(long userId);
    long getUserId();

    @Description(value="Исключительно для облегчения отладки на фронте, чтобы можно было передавать в ручки бэкенда UUID вместо паспортного id.")
    @RequestQueryProperty
    default void setUserUUID(UUID userUUID) {
    }

    default UUID getUserUUID() {
        return null;
    }

    default void setWebmasterUser(WebmasterUser user){
        setUserId(user == null ? 0L : user.getUserId());
    };
    default WebmasterUser getWebmasterUser(){
        long userId = getUserId();
        return userId == 0L ? null : new WebmasterUser(userId);
    }
}
