package ru.yandex.webmaster3.core.http.response;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import ru.yandex.webmaster3.core.searchquery.PathId;

import java.io.IOException;

/**
 * @author lester
 */
public class PathIdSerializer extends StdSerializer<PathId> {
    public PathIdSerializer() {
        super(PathId.class);
    }

    @Override
    public void serialize(PathId value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeString(value.toStringId());
    }
}
