package ru.yandex.webmaster3.core.http.response;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import ru.yandex.webmaster3.core.searchquery.QueryId;

import java.io.IOException;

/**
 * @author avhaliullin
 */
public class QueryIdSerializer extends StdSerializer<QueryId> {
    public QueryIdSerializer() {
        super(QueryId.class);
    }

    @Override
    public void serialize(QueryId value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeString(value.toStringId());
    }
}
