package ru.yandex.webmaster3.core.http.response;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import ru.yandex.webmaster3.core.util.IdUtils;

import java.io.IOException;
import java.net.URL;

/**
 * @author avhaliullin
 */
public class URLPrettySerializer extends StdScalarSerializer<URL> {
    public URLPrettySerializer() {
        super(URL.class);
    }

    @Override
    public void serialize(URL value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        StringBuilder result = new StringBuilder();
        result.append(value.getProtocol());
        result.append(":");
        result.append("//");
        result.append(IdUtils.IDN.toUnicode(value.getAuthority()));
        if (value.getPort() != -1) {
            result.append(":").append(value.getPort());
        }
        if (value.getPath() != null) {
            result.append(value.getPath());
        }
        if (value.getQuery() != null) {
            result.append('?');
            result.append(value.getQuery());
        }
        if (value.getRef() != null) {
            result.append("#");
            result.append(value.getRef());
        }
        jgen.writeString(result.toString());
    }
}
