package ru.yandex.webmaster3.core.http.response;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.IdUtils;

/**
 * @author aherman
 */
public class WebmasterHostIdSerializer extends StdSerializer<WebmasterHostId> {
    private final boolean useReadableHostname;

    public WebmasterHostIdSerializer() {
        super(WebmasterHostId.class);
        this.useReadableHostname = true;
    }

    public WebmasterHostIdSerializer(boolean useReadableHostname) {
        super(WebmasterHostId.class);
        this.useReadableHostname = useReadableHostname;
    }

    @Override
    public void serialize(WebmasterHostId hostId, JsonGenerator jgen, SerializerProvider provider)
            throws IOException, JsonGenerationException
    {
        if (useReadableHostname) {
            jgen.writeString(IdUtils.hostIdToWebIdString(hostId));
        } else {
            jgen.writeString(hostId.toStringId());
        }
    }
}
