package ru.yandex.webmaster3.core.iks.data;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

import java.util.List;

/**
 * Created by ifilippov5 on 25.04.18.
 */
public class IksTypedSample {
    private final int iks;
    private final SampleType sampleType;
    private final NeighborType neighborType;
    private final int shard;
    private final List<IksHostSampleItem> sample;

    public IksTypedSample(int iks, SampleType sampleType, NeighborType neighborType, int shard, List<IksHostSampleItem> sample) {
        this.iks = iks;
        this.sampleType = sampleType;
        this.neighborType = neighborType;
        this.shard = shard;
        this.sample = sample;
    }

    public int getIks() {
        return iks;
    }

    public SampleType getSampleType() {
        return sampleType;
    }

    public NeighborType getNeighborType() {
        return neighborType;
    }

    public int getShard() {
        return shard;
    }

    public List<IksHostSampleItem> getSample() {
        return sample;
    }

    public enum SampleType {
        TOP_100,
        NEIGHBORS
        ;

        public static final EnumResolver<SampleType> R = EnumResolver.er(SampleType.class);
    }

    public enum NeighborType {
        HIGHER,
        SAME,
        LOWER
        ;

        public static final EnumResolver<NeighborType> R = EnumResolver.er(NeighborType.class);
    }
}
