package ru.yandex.webmaster3.core.iks.data;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;

/**
 * Created by ifilippov5 on 09.08.18.
 */
public class Sqi implements Comparable<Sqi> {
    private final LocalDate date;
    private final String owner;
    private final Integer iks;
    private final String mainMirror;
    private final String title;
    private final Integer previousIks;

    public Sqi(LocalDate date, String owner, String mainMirror, Integer iks, Integer previousIks, String title) {
        this.date = date;
        this.owner = owner;
        this.iks = iks;
        this.mainMirror = mainMirror;
        this.title = title;
        this.previousIks = previousIks;
    }

    public Sqi(String owner, String mainMirror, Integer iks, Integer previousIks, String title) {
        this.owner = owner;
        this.iks = iks;
        this.mainMirror = mainMirror;
        this.title = title;
        this.previousIks = previousIks;
        this.date = null;
    }

    public LocalDate getDate() {
        return date;
    }

    public String getOwner() {
        return owner;
    }

    public Integer getIks() {
        return iks;
    }

    public String getMainMirror() {
        return mainMirror;
    }

    public String getTitle() {
        return title;
    }

    public Integer getPreviousIks() {
        return previousIks;
    }

    @Override
    public int compareTo(@NotNull Sqi o) {
        return iks.compareTo(o.iks);
    }
}
