package ru.yandex.webmaster3.core.link;

import lombok.Data;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.HttpCodeInfo;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.IdUtils;

/**
 * @author leonidrom
 */
@Data
public class BrokenLinkSample {
    public BrokenLinkSample(WebmasterHostId srcHostId, String srcPath, WebmasterHostId dstHostId, String dstUrl,
                            int dstHttpCode, DateTime linkDate) {
        this.srcHostId = srcHostId;
        this.srcPath = srcPath;
        this.srcUrl = IdUtils.hostIdToUrl(srcHostId) + srcPath;
        this.dstHostId = dstHostId;
        this.dstPath = dstUrl;
        this.dstUrl = IdUtils.hostIdToUrl(dstHostId) + dstPath;
        this.dstHttpCode = dstHttpCode;
        this.dstHttpCodeInfo = new HttpCodeInfo(dstHttpCode);
        this.linkDate = linkDate;
    }

    private final WebmasterHostId srcHostId;
    private final String srcPath;
    private final String srcUrl;
    private final WebmasterHostId dstHostId;
    private final String dstPath;
    private final String dstUrl;
    private final int dstHttpCode;
    private final HttpCodeInfo dstHttpCodeInfo;
    private final DateTime linkDate;
}
