package ru.yandex.webmaster3.core.link;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.joda.time.LocalDate;

/**
 * @author aherman
 */
public class DatePoint {
    private final LocalDate time;
    private final long value;

    @JsonCreator
    public DatePoint(LocalDate date, long value) {
        this.time = date;
        this.value = value;
    }

    public LocalDate getTime() {
        return time;
    }

    public long getValue() {
        return value;
    }

    public static DatePoint fromEntry(Map.Entry<LocalDate, Long> entry) {
        return new DatePoint(entry.getKey(), entry.getValue());
    }
}
