package ru.yandex.webmaster3.core.link;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * Created by ifilippov5 on 10.08.18.
 */
public enum ExternalHostSqiGroup implements IntEnum {
    UNKNOWN                                     (-1, -1, -1),
    SQI_LEVEL_0_10                              (10, 0, 10),
    SQI_LEVEL_10_20                             (20, 10, 20),
    SQI_LEVEL_20_50                             (30, 20, 50),
    SQI_LEVEL_50_100                            (40, 50, 100),
    SQI_LEVEL_100_250                           (50, 100, 250),
    SQI_LEVEL_250_500                           (60, 250, 500),
    SQI_LEVEL_500_1000                          (70, 500, 1000),
    SQI_LEVEL_1000_INF                          (80, 1000, Integer.MAX_VALUE),
    OTHER(90)
    ;

    ExternalHostSqiGroup(int value) {
        this.value = value;
    }

    ExternalHostSqiGroup(int value, Integer from) {
        this.value = value;
        this.from = from;
    }

    ExternalHostSqiGroup(int value, Integer from, Integer to) {
        this.value = value;
        this.from = from;
        this.to = to;
    }

    private int value;
    private Integer from;
    private Integer to;

    @Override
    public int value() {
        return value;
    }

    public Integer getFrom() {
        return from;
    }

    public Integer getTo() {
        return to;
    }

    public static ExternalHostSqiGroup getByFrom(int from) {
        for (ExternalHostSqiGroup sqiGroup : values()) {
            if (sqiGroup.getFrom() == from) {
                return sqiGroup;
            }
        }
        return UNKNOWN;
    }

    public static IntEnumResolver<ExternalHostSqiGroup> R = IntEnumResolver.r(ExternalHostSqiGroup.class);
}
