package ru.yandex.webmaster3.core.link;

import org.joda.time.Instant;
import ru.yandex.webmaster3.core.codes.LinkType;
import ru.yandex.webmaster3.core.data.HttpCodeInfo;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author aherman
 */
public class HostLinkSample {
    private final WebmasterHostId hostId;
    private final String hostUrl;
    private final String hostPath;
    private final Instant hostUrlLastAccessDate;
    private final int hostHttpCode;
    private final HttpCodeInfo hostHttpCodeInfo;

    private final boolean hostUrlBroken;

    private final WebmasterHostId sourceHostId;
    private final String sourceUrl;
    private final String sourcePath;
    private final Instant sourceUrlLastAccessDate;
    private final int sourceHttpCode;
    private final HttpCodeInfo sourceHttpCodeInfo;
    private final int sourceHostSqi;

    private final Instant linkDiscoverDate;
    private final String text;

    private final Instant deletionDate;


    public HostLinkSample(WebmasterHostId hostId, String hostUrl, String hostPath, Instant hostUrlLastAccessDate,
                          int hostHttpCode,
                          HttpCodeInfo hostHttpCodeInfo,
                          WebmasterHostId sourceHostId, String sourcePath, String sourceUrl, Instant sourceUrlLastAccessDate, int sourceHttpCode,
                          HttpCodeInfo sourceHttpCodeInfo, int sourceHostSqi, Instant linkDiscoverDate, String text,
                          Instant deletionDate)
    {
        this.hostId = hostId;
        this.hostUrl = hostUrl;
        this.hostPath = hostPath;
        this.hostUrlLastAccessDate = hostUrlLastAccessDate;
        this.hostHttpCode = hostHttpCode;
        this.hostHttpCodeInfo = hostHttpCodeInfo;
        this.sourceHostId = sourceHostId;
        this.sourcePath = sourcePath;
        this.sourceUrlLastAccessDate = sourceUrlLastAccessDate;
        this.sourceHttpCode = sourceHttpCode;
        this.sourceHttpCodeInfo = sourceHttpCodeInfo;
        this.sourceHostSqi = sourceHostSqi;
        this.sourceUrl = sourceUrl;
        this.linkDiscoverDate = linkDiscoverDate;
        this.text = text;
        this.deletionDate = deletionDate;
        this.hostUrlBroken = LinkType.isBroken(hostHttpCode);
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public String getHostUrl() {
        return hostUrl;
    }

    @Deprecated
    public String getHostPath() {
        return hostPath;
    }

    @Deprecated
    public Instant getHostUrlLastAccess() {
        return hostUrlLastAccessDate;
    }

    public Instant getHostUrlLastAccessDate() {
        return hostUrlLastAccessDate;
    }

    public int getHostHttpCode() {
        return hostHttpCode;
    }

    @Deprecated
    public HttpCodeInfo getHttpCodeInfo() {
        return hostHttpCodeInfo;
    }

    public HttpCodeInfo getHostHttpCodeInfo() {
        return hostHttpCodeInfo;
    }

    public WebmasterHostId getSourceHostId() {
        return sourceHostId;
    }

    @Deprecated
    public String getSourceFullUrl() {
        return sourceUrl;
    }

    public String getSourceUrl() {
        return sourceUrl;
    }

    @Deprecated
    public String getSourcePath() {
        return sourcePath;
    }

    @Deprecated
    public Instant getSourceHostUrlLast() {
        return sourceUrlLastAccessDate;
    }

    public Instant getSourceUrlLastAccessDate() {
        return sourceUrlLastAccessDate;
    }

    @Deprecated
    public int getSourceHostHttpCode() {
        return sourceHttpCode;
    }

    public int getSourceHttpCode() {
        return sourceHttpCode;
    }

    public HttpCodeInfo getSourceHttpCodeInfo() {
        return sourceHttpCodeInfo;
    }

    public int getSourceHostSqi() {
        return sourceHostSqi;
    }

    public Instant getLinkDiscoverDate() {
        return linkDiscoverDate;
    }

    public String getText() {
        return text;
    }

    @Deprecated
    public Instant getDeletedDate() {
        return deletionDate;
    }

    public Instant getDeletionDate() {
        return deletionDate;
    }

    public boolean isBroken() {
        return hostUrlBroken;
    }

    public boolean isHostUrlBroken() {
        return hostUrlBroken;
    }
}
