package ru.yandex.webmaster3.core.link;

import java.util.Map;
import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author aherman
 */
public class HostLinkStatistics {
    private final WebmasterHostId hostId;
    private final UUID linkGenerationUUID;
    private final Instant preparatCurrentTimestamp;
    private final Instant preparatPreviousTimestamp;
    private final long externalLinkUrlsCount;
    private final long externalLinkHostsCount;
    private final long externalLinkNewUrlsCount;
    private final long externalLinkNewHostsCount;
    private final long externalLinksGoneUrlsCount;
    private final long externalLinksGoneHostsCount;
    private final Map<ExternalHostSqiGroup, Long> externalLinksHostsSqiGroups;
    private final Map<Integer, Long> externalDetailedSqiInfo;
    private final Map<Integer, Long> externalLinkHttpCodes;
    private final Map<String, Long> externalLinksTldCount;

    private final long internalLinksUrlsCount;
    private final Map<Integer, Long> internalLinkHttpCodes;

    public HostLinkStatistics(WebmasterHostId hostId, UUID linkGenerationUUID, Instant preparatCurrentTimestamp,
            Instant preparatPreviousTimestamp, long externalLinkUrlsCount,
            long externalLinkHostsCount,
            long externalLinkNewUrlsCount, long externalLinkNewHostsCount, long externalLinksGoneUrlsCount,
            long externalLinksGoneHostsCount, long internalLinksUrlsCount,
            Map<ExternalHostSqiGroup, Long> externalLinksHostsSqiGroups,
            Map<Integer, Long> externalDetailedSqiInfo,
            Map<Integer, Long> internalLinkHttpCodes,
            Map<Integer, Long> externalLinkHttpCodes,
            Map<String, Long> externalLinksTldCount)
    {
        this.hostId = hostId;
        this.linkGenerationUUID = linkGenerationUUID;
        this.preparatCurrentTimestamp = preparatCurrentTimestamp;
        this.preparatPreviousTimestamp = preparatPreviousTimestamp;
        this.externalLinkUrlsCount = externalLinkUrlsCount;
        this.externalLinkHostsCount = externalLinkHostsCount;
        this.externalLinkNewUrlsCount = externalLinkNewUrlsCount;
        this.externalLinkNewHostsCount = externalLinkNewHostsCount;
        this.externalLinksGoneUrlsCount = externalLinksGoneUrlsCount;
        this.externalLinksGoneHostsCount = externalLinksGoneHostsCount;
        this.internalLinksUrlsCount = internalLinksUrlsCount;
        this.externalLinksHostsSqiGroups = externalLinksHostsSqiGroups;
        this.externalDetailedSqiInfo = externalDetailedSqiInfo;
        this.internalLinkHttpCodes = internalLinkHttpCodes;
        this.externalLinkHttpCodes = externalLinkHttpCodes;
        this.externalLinksTldCount = externalLinksTldCount;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public UUID getLinkGenerationUUID() {
        return linkGenerationUUID;
    }

    public HostLinkStatisticsGenerationId getGenerationId() {
        return new HostLinkStatisticsGenerationId(hostId, linkGenerationUUID);
    }

    public Instant getPreparatCurrentTimestamp() {
        return preparatCurrentTimestamp;
    }

    public Instant getPreparatPreviousTimestamp() {
        return preparatPreviousTimestamp;
    }

    public long getExternalLinkUrlsCount() {
        return externalLinkUrlsCount;
    }

    public long getExternalLinkHostsCount() {
        return externalLinkHostsCount;
    }

    public long getExternalLinkNewUrlsCount() {
        return externalLinkNewUrlsCount;
    }

    public long getExternalLinkNewHostsCount() {
        return externalLinkNewHostsCount;
    }

    public long getExternalLinksGoneUrlsCount() {
        return externalLinksGoneUrlsCount;
    }

    public long getExternalLinksGoneHostsCount() {
        return externalLinksGoneHostsCount;
    }

    public long getInternalLinksUrlsCount() {
        return internalLinksUrlsCount;
    }

    public Map<ExternalHostSqiGroup, Long> getExternalLinksHostsSqiGroups() {
        return externalLinksHostsSqiGroups;
    }

    public Map<Integer, Long> getExternalDetailedSqiInfo() {
        return externalDetailedSqiInfo;
    }

    public Map<Integer, Long> getInternalLinkHttpCodes() {
        return internalLinkHttpCodes;
    }

    public Map<Integer, Long> getExternalLinkHttpCodes() {
        return externalLinkHttpCodes;
    }

    public Map<String, Long> getExternalLinksTldCount() {
        return externalLinksTldCount;
    }
}
