package ru.yandex.webmaster3.core.link;

import java.util.UUID;

import org.joda.time.DateTime;
import org.joda.time.Instant;

import ru.yandex.webmaster3.core.data.BaseDataGeneration;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author aherman
 */
public class HostLinkStatisticsGeneration extends BaseDataGeneration {
    private final WebmasterHostId hostId;
    private final UUID linkGenerationUUID;
    private final Instant realDataCollectionDate;

    public HostLinkStatisticsGeneration(WebmasterHostId hostId, UUID linkGenerationUUID, Instant realDataCollectionDate, DateTime createDate,
            DateTime closeDate, DateTime updateDate, GenerationState state)
    {
        super(createDate, closeDate, updateDate, state);
        this.hostId = hostId;
        this.linkGenerationUUID = linkGenerationUUID;
        this.realDataCollectionDate = realDataCollectionDate;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public UUID getLinkGenerationUUID() {
        return linkGenerationUUID;
    }

    public Instant getRealDataCollectionDate() {
        return realDataCollectionDate;
    }

    public HostLinkStatisticsGenerationId getId() {
        return new HostLinkStatisticsGenerationId(hostId, linkGenerationUUID);
    }

    public HostLinkStatisticsGeneration withState(GenerationState state) {
        if (state == GenerationState.NEW) {
            return new HostLinkStatisticsGeneration(hostId, linkGenerationUUID, realDataCollectionDate, getCreateDate(), DateTime.now(), DateTime.now(), state);
        } else {
            return new HostLinkStatisticsGeneration(hostId, linkGenerationUUID, realDataCollectionDate, getCreateDate(), getCloseDate(), DateTime.now(), state);
        }
    }
}
