package ru.yandex.webmaster3.core.link;

import java.util.UUID;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author aherman
 */
public class HostLinkStatisticsGenerationId {
    private final WebmasterHostId hostId;
    private final UUID linkGenerationUUID;

    public HostLinkStatisticsGenerationId(WebmasterHostId hostId, UUID linkGenerationUUID) {
        this.hostId = hostId;
        this.linkGenerationUUID = linkGenerationUUID;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public UUID getLinkGenerationUUID() {
        return linkGenerationUUID;
    }

    public boolean isEmpty() {
        return linkGenerationUUID == null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        HostLinkStatisticsGenerationId that = (HostLinkStatisticsGenerationId) o;

        if (!hostId.equals(that.hostId)) {
            return false;
        }
        return !(linkGenerationUUID != null ? !linkGenerationUUID.equals(that.linkGenerationUUID) :
                that.linkGenerationUUID != null);

    }

    @Override
    public int hashCode() {
        int result = hostId.hashCode();
        result = 31 * result + (linkGenerationUUID != null ? linkGenerationUUID.hashCode() : 0);
        return result;
    }
}
