package ru.yandex.webmaster3.core.link;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum LinkHistoryIndicatorType implements IntEnum {
    UNKNOWN                         (0),

    EXTERNAL_LINK_HOSTS_COUNT       (1),
    EXTERNAL_LINK_URLS_COUNT        (2),
    EXTERNAL_LINK_NEW_HOSTS_COUNT   (3),
    EXTERNAL_LINK_NEW_URLS_COUNT    (4),
    EXTERNAL_LINK_GONE_HOSTS_COUNT  (5),
    EXTERNAL_LINK_GONE_URLS_COUNT   (6),

    // TCI больше нет, оставленно для истории
    // EXTERNAL_LINK_HOST_TCI_GROUPS   (7),

    INTERNAL_LINKS_URL_COUNT        (8),
    INTERNAL_LINKS_HTTP_CODES       (9),

    EXTERNAL_LINKS_HTTP_CODES       (10),
    EXTERNAL_LINKS_TLD_COUNT        (11),

    // TCI больше нет, оставленно для истории
    // EXTERNAL_LINKS_TCI_INFO         (12),

    EXTERNAL_LINK_HOST_SQI_GROUPS   (13),
    EXTERNAL_LINKS_SQI_INFO         (14)
    ;

    private final int value;

    private LinkHistoryIndicatorType(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<LinkHistoryIndicatorType> R = IntEnumResolver.r(LinkHistoryIndicatorType.class);
}
