package ru.yandex.webmaster3.core.link;

import org.joda.time.Instant;

/**
 * @author aherman
 */
public class LinksHistoryIndicator {
    private final Instant lastUpdateDate;
    private final LinkHistoryIndicatorType type;
    private final int httpCode;

    public LinksHistoryIndicator(Instant lastUpdateDate, LinkHistoryIndicatorType type, int httpCode) {
        this.lastUpdateDate = lastUpdateDate;
        this.type = type;
        this.httpCode = httpCode;
    }

    public Instant getLastUpdateDate() {
        return lastUpdateDate;
    }

    public LinkHistoryIndicatorType getType() {
        return type;
    }

    public int getHttpCode() {
        return httpCode;
    }
}
