package ru.yandex.webmaster3.core.links2;

import org.joda.time.Instant;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author tsyplyaev
 */
public class HostLinkSourceSample {
    private final WebmasterHostId hostId;
    private final int linksCount;
    private final int sourceHostSqi;
    private final Instant firstURLDate;
    private final Instant lastURLDate;
    private final Instant deletedDate;

    public HostLinkSourceSample(WebmasterHostId hostId, int linksCount, int sourceHostSqi, Instant firstURLDate,
                                Instant lastURLDate, Instant deletedDate)
    {
        this.hostId = hostId;
        this.linksCount = linksCount;
        this.sourceHostSqi = sourceHostSqi;
        this.firstURLDate = firstURLDate;
        this.lastURLDate = lastURLDate;
        this.deletedDate = deletedDate;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public int getLinksCount() {
        return linksCount;
    }

    public int getSourceHostSqi() {
        return sourceHostSqi;
    }

    public Instant getFirstURLDate() {
        return firstURLDate;
    }

    public Instant getLastURLDate() {
        return lastURLDate;
    }

    public Instant getDeletedDate() {
        return deletedDate;
    }
}
