package ru.yandex.webmaster3.core.logbroker.reader;

import lombok.extern.slf4j.Slf4j;
import ru.yandex.kikimr.persqueue.consumer.StreamListener;
import ru.yandex.kikimr.persqueue.consumer.transport.message.CommitMessage;
import ru.yandex.kikimr.persqueue.consumer.transport.message.inbound.ConsumerInitResponse;
import ru.yandex.kikimr.persqueue.consumer.transport.message.inbound.ConsumerReadResponse;
import ru.yandex.kikimr.persqueue.consumer.transport.message.inbound.data.MessageBatch;

import java.util.ArrayList;
import java.util.List;

/**
 * author: ishalaru
 * DATE: 30.07.2019
 */
@Slf4j
public class LogbrokerStreamConsumerListener implements StreamListener {
    private IDataProcessing dataProcess;
    private String sessionId;
    private boolean isActive;

    public LogbrokerStreamConsumerListener(IDataProcessing dataProcess) {
        this.dataProcess = dataProcess;
    }

    @Override
    public void onInit(ConsumerInitResponse init) {
        this.sessionId = init.getSessionId();
        isActive = true;
        log.debug("Created connection with logbroker: sessionId={}", sessionId);
    }

    @Override
    public void onRead(ConsumerReadResponse read, ReadResponder readResponder) {
        List<byte[]> rawMessages = new ArrayList<>();
        final List<MessageBatch> messages = read.getBatches();
        for (MessageBatch message : messages) {
            message.getMessageData().forEach(m -> rawMessages.add(m.getDecompressedData()));
        }
        final MessageContainer messageContainer = new MessageContainer(readResponder, rawMessages);

        try {
            dataProcess.process(messageContainer);
        } catch (Throwable t) {
            log.error("Exception while processing message", t);
            throw t;
        }
    }

    public boolean isActive() {
        return isActive;
    }

    @Override
    public void onCommit(CommitMessage commit) {
        //If message commited do nothing
    }

    @Override
    public void onClose() {
        //If connection is closed do nothing
        log.info("Connection with sessionId:{} is closed.", sessionId);
        isActive = false;
    }

    @Override
    public void onError(Throwable e) {
        log.error("Error in sessionId: " + sessionId, e);
        isActive = false;
    }
}
